__revision__ = '$Id: __init__.py,v 1.2 2002/07/17 22:58:13 jkloth Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = ['test_definingscope',
                     'test_metaobject',
                     'test_operand',
                     'test_property',
                     'test_scopedtype',
                     'test_specifier',
                     'test_type',
                     'test_metadata_util']
    RemoveTests(files, ignored_files)

    ordered_files = ['test_create_and_destroy',
                     'test_init_repo',
                     ]
    SortTests(files, ordered_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = []
    SortTests(dirs, ordered_dirs)

    return (dirs, files)
