import string, cStringIO, base64

from Ft.Server.Core import Constants
from Ft.Server.Protocols.Http import GetHandler
from Ft.Server.Protocols.Http import CommonHandler
from Ft.Lib import ObjectPrint
g_xmlText = """<?xml version = "1.0"?>
<ADDRBOOK>
    <ENTRY ID="pa">
        <NAME>Pieter Aaron</NAME>
        <ADDRESS>404 Error Way</ADDRESS>
        <PHONENUM DESC="Work">404-555-1234</PHONENUM>
        <PHONENUM DESC="Fax">404-555-4321</PHONENUM>
        <PHONENUM DESC="Pager">404-555-5555</PHONENUM>
        <EMAIL>pieter.aaron@inter.net</EMAIL>
    </ENTRY>
    <ENTRY ID="en">
        <NAME>Emeka Ndubuisi</NAME>
        <ADDRESS>42 Spam Blvd</ADDRESS>
        <PHONENUM DESC="Work">767-555-7676</PHONENUM>
        <PHONENUM DESC="Fax">767-555-7642</PHONENUM>
        <PHONENUM DESC="Pager">800-SKY-PAGEx767676</PHONENUM>
        <EMAIL>endubuisi@spamtron.com</EMAIL>
    </ENTRY>
    <ENTRY ID="vz">
        <NAME>Vasia Zhugenev</NAME>
        <ADDRESS>2000 Disaster Plaza</ADDRESS>
        <PHONENUM DESC="Work">000-987-6543</PHONENUM>
        <PHONENUM DESC="Cell">000-000-0000</PHONENUM>
        <EMAIL>vxz@magog.ru</EMAIL>
    </ENTRY>
</ADDRBOOK>
"""

g_xsltText = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
>

  <xsl:template match="/">
    <html>
    <head><title>Address Book</title>
    </head>
    <body>
    <h1><xsl:text>Tabulate Just Names and Phone Numbers</xsl:text></h1>
    <table><xsl:apply-templates/></table>
    </body>
    </html>
  </xsl:template>

  <xsl:template match="ENTRY">
    <tr>
      <xsl:apply-templates select='NAME'/>
      <td>
        <xsl:apply-templates select='PHONENUM'/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="NAME">
    <td align="center">
      <b><xsl:apply-templates/></b>
    </td>
  </xsl:template>

  <xsl:template match="PHONENUM">
    <xsl:text>(</xsl:text>
    <xsl:value-of select="@DESC"/>
    <xsl:text>) </xsl:text>
    <xsl:apply-templates/>
    <xsl:if test="not(position()=last())">
      <br/>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
"""
# Emacs "
def prime(tester):

    tester.startTest("Prime DB")
    repo = tester.test_data['util'].getRepo()

    if repo.hasContainer('/test.com'):
        repo.deleteContainer('/test.com')

    container = repo.createContainer('/test.com',1)
    doc1 = container.createRawFile('testDoc1', 'text/xml', g_xmlText)
    doc2 = container.createRawFile('testDoc2', 'text/xml', g_xmlText)
    sheet1 = container.createRawFile('testSheet1', 'text/xml', g_xsltText)

    container.setWorldRead()
    doc1.setWorldRead()
    doc2.setReadAcl(tester.test_data['util'].aclIdent)
    sheet1.setWorldRead()

    repo.txCommit()
    tester.testDone()
    
def get_by_name_host(tester):

    tester.startTest("Get By Name")

    g = GetHandler.GetHandler({})

    #Create a request for the uri
    headers = {}
    body = cStringIO.StringIO()
    request = CommonHandler.Request('/testDoc1', headers, body, host='test.com',configFile=tester.test_data['util'].configFileName)

    res = g.handle(request)
    try:
        tester.compare(200,res.code)
        tester.compare(g_xmlText,res.body)
    except:
        ObjectPrint.pprint(res)
        raise
    tester.testDone()

def get_by_name_doc_root(tester):

    tester.startTest("Get By Name w/ Document Root")

    g = GetHandler.GetHandler({'DocumentRoot' : '/test.com'})

    #Create a request for the uri
    headers = {}
    body = cStringIO.StringIO()
    request = CommonHandler.Request('/testDoc1', headers, body,configFile=tester.test_data['util'].configFileName)

    res = g.handle(request)
    try:
        tester.compare(200,res.code)
        tester.compare(g_xmlText,res.body)
    except:
        ObjectPrint.pprint(res)
        raise
    tester.testDone()



def get_by_urn(tester):

    tester.startTest("Get By Urn")

    g = GetHandler.GetHandler({'UriQueryPath' : '/uri'})


    #Create a request for the uri
    headers = {}
    body = cStringIO.StringIO()
    request = CommonHandler.Request('/uri?uri=/test.com/testDoc1',headers,body,configFile=tester.test_data['util'].configFileName)

    res = g.handle(request)
    tester.compare(200,res.code)
    tester.compare(g_xmlText,res.body)
    tester.testDone()
    return


def get_bad_alias(tester):

    tester.startTest("Get Bad Alias")
    #Request by alias

    g = GetHandler.GetHandler({'DocumentRoot' : '/test.com'})


    #Create a request for the uri
    headers = {}
    body = cStringIO.StringIO()
    request = CommonHandler.Request('/foo',headers,body,configFile=tester.test_data['util'].configFileName)

    res = g.handle(request)
    tester.compare(404,res.code)
    tester.testDone()


def get_no_access(tester):

    tester.startTest("Get w/o access")
    #Request by alias

    g = GetHandler.GetHandler({'DocumentRoot' : '/test.com'})


    #Create a request for the uri
    headers = {}
    body = cStringIO.StringIO()
    request = CommonHandler.Request('/testDoc2',headers,body,configFile=tester.test_data['util'].configFileName)

    res = g.handle(request)
    tester.compare(403,res.code)
    tester.testDone()

def auth_challenge(tester):

    tester.startTest("Auth challenge")
    #Request by alias

    g = GetHandler.GetHandler({'DocumentRoot' : '/test.com',
                               'AuthenticationRealm' : '4SS',
                               })


    #Create a request for the uri
    headers = {}
    body = cStringIO.StringIO()
    request = CommonHandler.Request('/foo',headers,body,configFile=tester.test_data['util'].configFileName)

    res = g.handle(request)
    tester.compare(401,res.code)
    tester.testDone()

def get_xslt(tester):

    tester.startTest("Get With Xslt")

    g = GetHandler.GetHandler({'DocumentRoot' : '/test.com'})


    #Create a request for the uri
    headers = {}
    body = cStringIO.StringIO()
    request = CommonHandler.Request('/testDoc1?xslt=testSheet1',headers,body,configFile=tester.test_data['util'].configFileName)

    res = g.handle(request)

    tester.compare(200,res.code)
    tester.testDone()
    return


def Test(tester):
    tester.startGroup("Default Get Handler")
    prime(tester)

    get_by_name_host(tester)
    get_by_name_doc_root(tester)
    get_by_urn(tester)
    get_bad_alias(tester)
    get_no_access(tester)
    auth_challenge(tester)
    get_by_urn(tester)
    get_xslt(tester)
    
    tester.groupDone()

