#!/usr/bin/python
########################################################################
#
# File Name:            GenerateUnion.py
#
# Documentation:        http://docs.4suite.org/4ODS/GenerateUnion.py.html
#

#Desc.
#WWW: http://4suite.org/4ODS        e-mail: support@4suite.org

#Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
#See  http://4suite.org/COPYRIGHT  for license and copyright information

import os, OdlUtil, GenerateType

from Ft.Ods.MetaData import MetaKind
from Ft.Ods import Constants
from Ft.Ods.Exception import FtodsGenerationError


import GenerateType

# File creation algorithms
def GenerateStubs(union, params,fileName,useName,toSet):
    """File creation algorithms"""


    outFile = open(fileName,'a')

    outFile.write("\n# Begin Generation of Union %s\n\n" % union.name)

    outFile.write("from Ft.Ods import Union\n")

    outFile.write("class _%s(Union.Union):\n" % useName)

    outFile.write("    _switchType = %d\n" % union.switch_type._4ods_getOdmgType())
    outFile.write("    _switchRepoId = %d\n" % union.switch_type._4ods_getId())

    firstCase = None
    defaultCaseFound = 0
    cases = {}
    names = []
    for curCase in union.cases:
        names.append(curCase.name)
        t = OdlUtil.NormalizeTypeDefinition(curCase.type)
        ot = t._4ods_getOdmgType()
        if Constants.g_primitiveTypes[ot]:
            default = eval(GenerateType.g_pyDefaultFromOdlType[t._4ods_getOdl('')])
        elif Constants.g_literalTypes[ot]:
            if t._4ods_getOdmgType() in [Constants.Types.STRUCTURE,
                                         Constants.Types.ENUMERATION]:
                rid = t._4ods_getId()
            else:
                rid = -1

            default = rid

        elif ot in [Constants.Types.POBJECT,Constants.Types.ROBJECT]:
            default = t._4ods_getId()
        elif Constants.g_listTypes[ot]:
            default = t._4ods_getId()
        else:
            raise FtodsGenerationError(msg="Union Case of type %s no supported" % t)

        if not len(curCase.case_labels):
            defaultCaseFound = 1
            cases[None] = (curCase.name,ot,default)
        else:
            for curLabel in curCase.case_labels:
                if firstCase is None:
                    firstCase = curLabel.value()
                cases[curLabel.value()] = (curCase.name,ot,default)


    if defaultCaseFound:
        defaultCase = None
    else:
        defaultCase = firstCase

    outFile.write("    _cases = %s\n" % repr(cases))
    outFile.write("    _defaultCase = %s\n" % repr(defaultCase))

    
    outFile.write("    _typeId = %d\n" % union._4ods_getId())
    outFile.write("    _typeIds = (%d,)\n" % union._4ods_getId())
    outFile.write("    _tupleNames = %s\n" % repr(names))

    outFile.write("\n\n")
    outFile.write("def %s(discriminate,value):\n" % useName)
    outFile.write("    return _%s(None,(discriminate,value))\n" % useName)


    if toSet:
        parentName, actualName = toSet
        outFile.write("%s.%s=%s\n" % (parentName,actualName,useName))

    outFile.write("\n# End Generation of Structure %s\n\n" % union.name)

    outFile.close()

    params.literalFiles.append((Constants.Types.UNION,fileName,['_'+useName]))
    return




