/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.javacc;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.javacc.JavaCC;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;

public class JJTree
extends Task {
    private static final String OUTPUT_FILE = "OUTPUT_FILE";
    private static final String BUILD_NODE_FILES = "BUILD_NODE_FILES";
    private static final String MULTI = "MULTI";
    private static final String NODE_DEFAULT_VOID = "NODE_DEFAULT_VOID";
    private static final String NODE_FACTORY = "NODE_FACTORY";
    private static final String NODE_SCOPE_HOOK = "NODE_SCOPE_HOOK";
    private static final String NODE_USES_PARSER = "NODE_USES_PARSER";
    private static final String STATIC = "STATIC";
    private static final String VISITOR = "VISITOR";
    private static final String NODE_PACKAGE = "NODE_PACKAGE";
    private static final String VISITOR_EXCEPTION = "VISITOR_EXCEPTION";
    private static final String NODE_PREFIX = "NODE_PREFIX";
    private final Hashtable optionalAttrs = new Hashtable();
    private String outputFile = null;
    private static final String DEFAULT_SUFFIX = ".jj";
    private File outputDirectory = null;
    private File target = null;
    private File javaccHome = null;
    private CommandlineJava cmdl = new CommandlineJava();

    public void setBuildnodefiles(boolean buildNodeFiles) {
        this.optionalAttrs.put(BUILD_NODE_FILES, new Boolean(buildNodeFiles));
    }

    public void setMulti(boolean multi) {
        this.optionalAttrs.put(MULTI, new Boolean(multi));
    }

    public void setNodedefaultvoid(boolean nodeDefaultVoid) {
        this.optionalAttrs.put(NODE_DEFAULT_VOID, new Boolean(nodeDefaultVoid));
    }

    public void setNodefactory(boolean nodeFactory) {
        this.optionalAttrs.put(NODE_FACTORY, new Boolean(nodeFactory));
    }

    public void setNodescopehook(boolean nodeScopeHook) {
        this.optionalAttrs.put(NODE_SCOPE_HOOK, new Boolean(nodeScopeHook));
    }

    public void setNodeusesparser(boolean nodeUsesParser) {
        this.optionalAttrs.put(NODE_USES_PARSER, new Boolean(nodeUsesParser));
    }

    public void setStatic(boolean staticParser) {
        this.optionalAttrs.put(STATIC, new Boolean(staticParser));
    }

    public void setVisitor(boolean visitor) {
        this.optionalAttrs.put(VISITOR, new Boolean(visitor));
    }

    public void setNodepackage(String nodePackage) {
        this.optionalAttrs.put(NODE_PACKAGE, new String(nodePackage));
    }

    public void setVisitorException(String visitorException) {
        this.optionalAttrs.put(VISITOR_EXCEPTION, new String(visitorException));
    }

    public void setNodeprefix(String nodePrefix) {
        this.optionalAttrs.put(NODE_PREFIX, new String(nodePrefix));
    }

    public void setOutputdirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setOutputfile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void setJavacchome(File javaccHome) {
        this.javaccHome = javaccHome;
    }

    public JJTree() {
        this.cmdl.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
    }

    public void execute() throws BuildException {
        Enumeration iter = this.optionalAttrs.keys();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            Object value = this.optionalAttrs.get(name);
            this.cmdl.createArgument().setValue("-" + name + ":" + value.toString());
        }
        if (this.target == null || !this.target.isFile()) {
            throw new BuildException("Invalid target: " + this.target);
        }
        File javaFile = null;
        if (this.outputDirectory == null) {
            this.cmdl.createArgument().setValue("-OUTPUT_DIRECTORY:" + this.getDefaultOutputDirectory());
            javaFile = new File(this.createOutputFileName(this.target, this.outputFile, null));
        } else {
            if (!this.outputDirectory.isDirectory()) {
                throw new BuildException("'outputdirectory' " + this.outputDirectory + " is not a directory.");
            }
            this.cmdl.createArgument().setValue("-OUTPUT_DIRECTORY:" + this.outputDirectory.getAbsolutePath().replace('\\', '/'));
            javaFile = new File(this.createOutputFileName(this.target, this.outputFile, this.outputDirectory.getPath()));
        }
        if (javaFile.exists() && this.target.lastModified() < javaFile.lastModified()) {
            this.log("Target is already built - skipping (" + this.target + ")", 3);
            return;
        }
        if (this.outputFile != null) {
            this.cmdl.createArgument().setValue("-OUTPUT_FILE:" + this.outputFile.replace('\\', '/'));
        }
        this.cmdl.createArgument().setValue(this.target.getAbsolutePath());
        this.cmdl.setClassname(JavaCC.getMainClass(this.javaccHome, 2));
        Path classpath = this.cmdl.createClasspath(this.getProject());
        File javaccJar = JavaCC.getArchiveFile(this.javaccHome);
        classpath.createPathElement().setPath(javaccJar.getAbsolutePath());
        classpath.addJavaRuntime();
        Commandline.Argument arg = this.cmdl.createVmArgument();
        arg.setValue("-mx140M");
        arg.setValue("-Dinstall.root=" + this.javaccHome.getAbsolutePath());
        Execute process = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 2), null);
        this.log(this.cmdl.describeCommand(), 3);
        process.setCommandline(this.cmdl.getCommandline());
        try {
            if (process.execute() != 0) {
                throw new BuildException("JJTree failed.");
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to launch JJTree", (Throwable)e);
        }
    }

    private String createOutputFileName(File target, String optionalOutputFile, String outputDirectory) {
        optionalOutputFile = this.validateOutputFile(optionalOutputFile, outputDirectory);
        String jjtreeFile = target.getAbsolutePath().replace('\\', '/');
        if (optionalOutputFile == null || optionalOutputFile.equals("")) {
            String currentSuffix;
            int suffixPos;
            int filePos = jjtreeFile.lastIndexOf("/");
            if (filePos >= 0) {
                jjtreeFile = jjtreeFile.substring(filePos + 1);
            }
            optionalOutputFile = (suffixPos = jjtreeFile.lastIndexOf(46)) == -1 ? jjtreeFile + DEFAULT_SUFFIX : ((currentSuffix = jjtreeFile.substring(suffixPos)).equals(DEFAULT_SUFFIX) ? jjtreeFile + DEFAULT_SUFFIX : jjtreeFile.substring(0, suffixPos) + DEFAULT_SUFFIX);
        }
        if (outputDirectory == null || outputDirectory.equals("")) {
            outputDirectory = this.getDefaultOutputDirectory();
        }
        return (outputDirectory + "/" + optionalOutputFile).replace('\\', '/');
    }

    private String validateOutputFile(String outputFile, String outputDirectory) throws BuildException {
        if (outputFile == null) {
            return null;
        }
        if (outputDirectory == null && (outputFile.startsWith("/") || outputFile.startsWith("\\"))) {
            String relativeOutputFile = this.makeOutputFileRelative(outputFile);
            this.setOutputfile(relativeOutputFile);
            return relativeOutputFile;
        }
        String root = this.getRoot(new File(outputFile)).getAbsolutePath();
        if (root.length() > 1 && outputFile.startsWith(root.substring(0, root.length() - 1))) {
            throw new BuildException("Drive letter in 'outputfile' not supported: " + outputFile);
        }
        return outputFile;
    }

    private String makeOutputFileRelative(String outputFile) {
        StringBuffer relativePath = new StringBuffer();
        String defaultOutputDirectory = this.getDefaultOutputDirectory();
        int nextPos = defaultOutputDirectory.indexOf(47);
        int startPos = nextPos + 1;
        while (startPos > -1 && startPos < defaultOutputDirectory.length()) {
            relativePath.append("/..");
            nextPos = defaultOutputDirectory.indexOf(47, startPos);
            startPos = nextPos == -1 ? nextPos : nextPos + 1;
        }
        relativePath.append(outputFile);
        return relativePath.toString();
    }

    private String getDefaultOutputDirectory() {
        return this.getProject().getBaseDir().getAbsolutePath().replace('\\', '/');
    }

    private File getRoot(File file) {
        File root = file.getAbsoluteFile();
        while (root.getParent() != null) {
            root = root.getParentFile();
        }
        return root;
    }
}

