/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.util;

/**
 * @author    Ara Abrahamian (ara_e_w@yahoo.com)
 * @created   May 31, 2002
 * @version   $Revision: 1.5 $
 */
public final class XDocletUtilMessages
{
    /**
     * @msg.bundle   msg="Initializing XML parser failed."
     */
    public final static String INIT_FAILED = "INIT_FAILED";

    /**
     * @msg.bundle   msg="Generated file [{0}:line {1}] Message=[{2}] is not valid according to its DTD or XML Schema.
     *      This might be due to some missing tags in your source."
     */
    public final static String GENERATED_XML_INVALID = "GENERATED_XML_INVALID";

    /**
     * @msg.bundle   msg="The validateion for the generated file [{0}] failed. Message=[{2}] ."
     */
    public final static String PARSING_FAILED = "PARSING_FAILED";

    /**
     * @msg.bundle   msg="Exception reading merge file. {0}"
     */
    public final static String EXCEPTION_READING_MERGE_FILE = "EXCEPTION_READING_MERGE_FILE";

    /**
     * @msg.bundle   msg="WARNING: Can't validate against the XML Schema because the SAX Parser does not support JAXP
     *      1.2 XML Schema validation. Please make sure that a JAXP 1.2 SAX Parser is available in the classpath (i.e.
     *      Xerces-J)."
     */
    public final static String PARSER_DOES_NOT_SUPPORT_XSD_VALIDATION = "PARSER_DOES_NOT_SUPPORT_XSD_VALIDATION";

    /**
     * @msg.bundle   msg="WARNING: Can't validate against the XML Schema because no namespace-aware SAX Parser could be
     *      found. Please make sure that a JAXP 1.2 SAX Parser is available in the classpath (i.e. Xerces-J)."
     */
    public final static String NO_NAMESPACE_AWARE_SAX_PARSER = "NO_NAMESPACE_AWARE_SAX_PARSER";
}
