=begin
= Summary
Library for command line option analysis.

features:
(1) It is possible <option switch of a short form and a long form> to
    exist together. It is also possible in one to bring the switch of
    a short form together.
(2) It is possible to write bringing specification and the handler of
    the switch together respectively in one place.
(3) The argument of the switch is converted into the class which
    automatically specifies it.
(4) The option summary can be made.
(5) The option can be added on the way later.

=end #'#"#`#
=begin

== Class tree
   * ((<OptionParser>)) front end
   * ((<OptionParser::Switch>)) each switches
   * ((<OptionParser::List>)) options list
   * ((<OptionParser::ParseError>)) errors on parsing
     * ((<OptionParser::AmbiguousOption>))
     * ((<OptionParser::NeedlessArgument>))
     * ((<OptionParser::MissingArgument>))
     * ((<OptionParser::InvalidOption>))
     * ((<OptionParser::InvalidArgument>))
       * ((<OptionParser::AmbiguousArgument>))

== Object relations
   +--------------+
   | OptionParser |<>-----+
   +--------------+       |          	         +--------+
                          |          	       ,-| Switch |
        on_head -------->+---------------+    /  +--------+
        accept/reject -->| List        	 |<|>-
                         |             	 |<|>-  +----------+
        on ------------->+---------------+    `-| argument |
                         :             	 :      |  class   |
                         +---------------+      |==========|
        on_tail -------->|             	 |      |pattern   |
                         +---------------+      |----------|
   OptionParser.accept ->| DefaultList 	 |      |converter |
                reject   |(shared between|      +----------+
                         | all instances)|
                         +---------------+

=end #'#"#`#
=begin
= Classes & Modules
=end #'#"#`#
=begin private
== ((:OptionParser::Completion:))
Keyword completion module.
=end #'#"#`#
=begin private
--- OptionParser::Completion#complete(key[, pat])
    Searches ((|key|)), or ((|pat|)) with completion if not found.
    :Parameters:
      : ((|key|))
        keyword to search.
      : ((|pat|))
        completion pattern.
=end #'#"#`#
=begin private
--- OptionParser::Completion#convert(opt, *val)
    Extracts the first element from result of
    ((<OptionParser::Completion#complete>)).
=end #'#"#`#
=begin private
== ((:OptionParser::Filling:))
Extends method (({fill})) like as (({Array#fill})).
=end #'#"#`#
=begin private
== ((:OptionParser::OptionMap:))
Map from option/keyword string to object with completion.
=== Superclass
(({Hash}))
=== Including modules
((<OptionParser::Completion>)), ((<OptionParser::Filling>))
=end #'#"#`#
=begin
== ((:OptionParser::Switch:))
Individual switch class.
=end #'#"#`#
=begin private
=== Class methods
=end
=begin private
--- OptionParser::Switch.guess(arg)
    Guesses argument style from ((|arg|)).
    Returns corresponding ((<OptionParser::Switch>)) subclass.
=end #'#"#`#
=begin private
--- OptionParser::Switch.new
=end #'#"#`#
=begin
=== Instance methods
=end
=begin private
--- OptionParser::Switch#parse_arg(arg) {non-serious error handler}
    Parses argument and returns rest of ((|arg|)), and matched portion
    to the argument pattern.
    :Parameters:
      : ((|arg|))
        option argument to be parsed.
      : (({block}))
        yields when the pattern doesn't match sub-string.
=end #'#"#`#
=begin
--- OptionParser::Switch#parse(arg, val) {semi-error handler}
    Parses argument, convert and returns ((|arg|)), ((|block|)) and
    result of conversion.
    : Arguments to ((|@conv|))
      substrings matched to ((|@pattern|)), ((|$&|)), ((|$1|)),
      ((|$2|)) and so on.
    :Parameters:
      : ((|arg|))
        argument string follows the switch.
      : ((|val|))
        following argument.
      : (({block}))
        (({yields})) at semi-error condition, instead of raises exception.
=end #'#"#`#
=begin private
--- OptionParser::Switch#summarize(sdone, ldone, width, max, indent)
    Makes summary strings.
    :Parameters:
      : ((|sdone|))
        already summarized short style options keyed hash.
      : ((|ldone|))
        already summarized long style options keyed hash.
      : ((|width|))
        width of left side, option part. in other word, right side,
        description part strings start at ((|width|)) column.
      : ((|max|))
        maximum width of left side, options are filled within ((|max|)) columns.
      : ((|indent|))
        prefix string indents each summarized lines.
      : (({block}))
        to be passed each lines(without newline).
=end #'#"#`#
=begin private
--- OptionParser::Switch#-@
    Instantiates negated boolean switch, which calls ((|@block|)) with
    inversed value.
=end #'#"#`#
=begin private
== Switch classes
=end #'#"#`#
=begin private
=== ((:OptionParser::Switch::NoArgument:))
Switch that takes no arguments.
==== Superclass
((<OptionParser::Switch>))
==== Instance methods
--- OptionParser::Switch::NoArgument#parse
    Raises an exception if any arguments given.
=end #'#"#`#
=begin private
=== ((:OptionParser::Switch::RequiredArgument:))
Switch that takes an argument.
==== Superclass
((<OptionParser::Switch>))
==== Instance methods
--- OptionParser::Switch::RequiredArgument#parse
    Raises an exception if argument is not present.
=end #'#"#`#
=begin private
=== ((:OptionParser::Switch::OptionalArgument:))
Switch that can omit argument.
==== Superclass
((<OptionParser::Switch>))
==== Instance methods
--- OptionParser::Switch::OptionalArgument#parse
    Parses argument if given, or uses default value.
=end #'#"#`#
=begin
== ((:OptionParser::List:))
Simple option list providing mapping from short and/or long option
string to ((<OptionParser::Switch>)), and mapping from acceptable
argument to matching pattern and converter pair.  Also provides
summary feature.
=end #'#"#`#
=begin
=== Class methods
=end #'#"#`#
=begin private
--- OptionParser::List.new
    Just initializes all instance variables.
=end #'#"#`#
=begin
=== Instance methods
=end #'#"#`#
=begin
--- OptionParser::List#atype
    Map from acceptable argument types to pattern and converter pairs.
--- OptionParser::List#short
    Map from short style option switches to actual switch objects.
--- OptionParser::List#long
    Map from long style option switches to actual switch objects.
--- OptionParser::List#list
    List of all switches and summary string.
=end #'#"#`#
=begin private
--- OptionParser::List#accept(type[, pattern]) {...}
    see ((<OptionParser.accept>)).
--- OptionParser::List#reject(type)
    see ((<OptionParser.reject>)).
=end #'#"#`#
=begin private
--- OptionParser::List#update(sw, sopts, lopts, nlopts = nil)
    Adds ((|sw|)) according to ((|sopts|)), ((|lopts|)) and
    ((|nlopts|)).
    :Parameters:
      : ((|sw|))
        ((<OptionParser::Switch>)) instance to be added.
      : ((|sopts|))
        short style options list.
      : ((|lopts|))
        long style options list.
      : ((|nlopts|))
        negated long style options list.
=end #'#"#`#
=begin
--- OptionParser::List#prepend(switch, short_opts, long_opts, nolong_opts)
    Inserts ((|switch|)) at head of the list, and associates short,
    long and negated long options.
--- OptionParser::List#append(switch, short_opts, long_opts, nolong_opts)
    Appends ((|switch|)) at tail of the list, and associates short,
    long and negated long options.
    :Parameters:
      : ((|switch|))
        ((<OptionParser::Switch>)) instance to be inserted.
      : ((|short_opts|))
        list of short style options.
      : ((|long_opts|))
        list of long style options.
      : ((|nolong_opts|))
        list of long style options with (({"no-"})) prefix.
=end #'#"#`#
=begin
--- OptionParser::List#search(id, key) [{block}]
    Searches ((|key|)) in ((|id|)) list.
    :Parameters:
      : ((|id|))
        searching list.
      : ((|k|))
        searching key.
      : (({Block}))
        yielded with the found value when succeeded.
=end #'#"#`#
=begin
--- OptionParser::List#complete(id, opt, *pat, &block)
    Searches list ((|id|)) for ((|opt|)) and ((|*pat|)).
    :Parameters:
      : ((|id|))
        searching list.
      : ((|opt|))
        searching key.
      : ((|*pat|))
        optional pattern for completion.
      : (({Block}))
        yielded with the found value when succeeded.
=end #'#"#`#
=begin
--- OptionParser::List#summarize(*args) {...}
    Making summary table, yields the (({block})) with each lines.
    Each elements of (({@list})) should be able to (({summarize})).
    :Parameters:
      : ((|args|))
        passed to elements#summarize through.
      : (({block}))
        to be passed each lines(without newline).
=end #'#"#`#
=begin private
== ((:OptionParser::CompletingHash:))
(({Hash})) with completion search feature.
=== Superclass
(({Hash}))
=== Including modules
((<OptionParser::Completion>))
=end #'#"#`#
=begin private
=== Instance methods
--- OptionParser::CompletingHash#match(key)
    Completion for hash key.
=end #'#"#`#
=begin
== ((:OptionParser:))
The front-end of (({OptionParser})).
=end #'#"#`#
=begin
=== Constants
=end #'#"#`#
=begin
--- OptionParser::ArgumentStyle
    Enumeration of acceptable argument styles; possible values are:
    : OptionParser::NO_ARGUMENT
      the switch takes no arguments. ((({:NONE}))) 
    : OptionParser::REQUIRED_ARGUMENT
      the switch requires an argument. ((({:REQUIRED})))
    : OptionParser::OPTIONAL_ARGUMENT
      the switch requires an optional argument, that is, may take or
      not. ((({:OPTIONAL})))

    Use like (({--switch=argument}))(long style) or
    (({-Xargument}))(short style). For short style, only portion
    matched to ((<argument pattern>)) is dealed as argument.
=end #'#"#`#
=begin private
--- OptionParser::DefaultList
    Switches common used such as '--', and also provides default
    argument classes
=end #'#"#`#
=begin undocumented
=== Default options
Default options, which never appear in option summary.
--- --help
    Shows option summary.
--- --version
    Shows version string if (({::Version})) is defined.
=end #'#"#`#
=begin
=== Class methods
=end #'#"#`#
=begin
--- OptionParser.with([banner[, width[, indent]]]) [{...}]
    Initializes new instance, and evaluates the block in context of
    the instance if called as iterator.  This behavior is equivalent
    to older (({new})).  This is ((*deprecated*)) method.
    
    cf. ((<OptionParser.new>))
    :Parameters:
      : ((|banner|))
        banner message.
      : ((|width|))
        summary width.
      : ((|indent|))
        summary indent.
      : (({Block}))
        to be evaluated in the new instance context.
=end #'#"#`#
=begin
--- OptionParser.inc(arg[, default])
--- OptionParser#inc(arg[, default])
    Returns incremented value of ((|default|)) according to ((|arg|)).
=end
=begin
--- OptionParser.new([banner[, width[, indent]]]) [{...}]
    Initializes the instance, and yields itself if called as iterator.
    :Parameters:
      : ((|banner|))
        banner message.
      : ((|width|))
        summary width.
      : ((|indent|))
        summary indent.
      : (({Block}))
        to be evaluated in the new instance context.
=end #'#"#`#
=begin
--- OptionParser.terminate([arg])
    Terminates option parsing. Optional parameter ((|arg|)) would be
    pushed back if given.
    :Parameters:
      : ((|arg|))
        string pushed back to be first non-option argument
=end #'#"#`#
=begin
--- OptionParser.accept(t, [pat]) {...}
--- OptionParser#accept(t, [pat]) {...}
    Directs to accept specified class argument.
    :Parameters:
      : ((|t|))
        argument class specifier, any object including Class.
      : ((|pat|))
        pattern for argument, defaulted to ((|t|)) if it respond to (({match})).
      : (({Block}))
        receives argument string and should be convert to desired class.
=end #'#"#`#
=begin
--- OptionParser.reject(t)
--- OptionParser#reject(t)
    Directs to reject specified class argument.
    :Parameters:
      : ((|t|))
        argument class specifier, any object including Class.
=end #'#"#`#
=begin private
--- OptionParser.yieldproc(*args) {block}
    Yields (({Proc})) or (({Method})) as iterator block with arguments
    ((|args|)).
    :Parameters:
      : ((|*args|))
        arguments to (({Block}))
      : (({Block}))
        (({Proc})) or (({Method})) to call. Must be passed as block.
=end #'#"#`#
=begin
=== Instance methods
=end #'#"#`#
=begin
--- OptionParser#banner
--- OptionParser#banner=(heading)
    Heading banner preceding summary.
--- OptionParser#summary_width
--- OptionParser#summary_width=(width)
    Width for option list portion of summary. Must be (({Numeric})).
--- OptionParser#summary_indent
--- OptionParser#summary_indent=(indent)
    Indentation for summary. Must be (({String})) (or have (({+ String}))).
--- OptionParser#program_name
--- OptionParser#program_name=(name)
    Program name to be emitted in error message and default banner,
    defaulted to (({$0})).
=end #'#"#`#
=begin
--- OptionParser#version
--- OptionParser#version=(ver)
    Version.
--- OptionParser#release
--- OptionParser#release=(rel)
    Release code.
--- OptionParser#ver
    Returns version string from ((<program_name>)), (({version})) and
    (({release})).
=end #'#"#`#
=begin
--- OptionParser#top
    Subject of ((<on>))/((<on_head>)), ((<accept>))/((<reject>)).
=end #'#"#`#
=begin
--- OptionParser#base
    Subject of ((<on_tail>)).
=end #'#"#`#
=begin
--- OptionParser#new
    Pushes a new (({List})).
=end #'#"#`#
=begin
--- OptionParser#remove
    Removes the last (({List})).
=end #'#"#`#
=begin
--- OptionParser#summarize(to = [], width = @summary_width, max = width - 1, indent = @summary_indent)
    Puts option summary into ((|to|)), and returns ((|to|)).
    :Parameters:
      : ((|to|))
        output destination, which must have method ((|<<|)). Defaulted to (({[]})).
      : ((|width|))
        width of left side. Defaulted to ((|@summary_width|))
      : ((|max|))
        maximum length allowed for left side. Defaulted to (({((|width|)) - 1}))
      : ((|indent|))
        indentation. Defaulted to ((|@summary_indent|))
      : (({Block}))
        yields with each line if called as iterator.
=end #'#"#`#
=begin
--- OptionParser#to_str
--- OptionParser#to_s
    Returns option summary string.
=end #'#"#`#
=begin
--- OptionParser#to_a
    Returns option summary list.
=end #'#"#`#
=begin
--- OptionParser#switch
    Creates ((<OptionParser::Switch>)).
    :Parameters:
      : ((|*opts|))
        option definition:
        : argument style
          see ((<OptionParser::ArgumentStyle>))
        : argument pattern
          acceptable option argument format, must pre-defined with
          ((<OptionParser.accept>)) or ((<OptionParser#accept>)), or
          (({Regexp})). This can appear once or assigned as (({String}))
          if not present, otherwise causes exception (({ArgumentError})).
          
          cf. ((<Acceptable argument classes>)).
        : Hash
        : Array
          possible argument values.
        : Proc
        : Method
          alternative way to give the ((*handler*)).
        : "--switch=MANDATORY", "--switch[=OPTIONAL]", "--switch"
          specifies long style switch that takes ((*mandatory*)),
          ((*optional*)) and ((*no*)) argument, respectively.
        : "-xMANDATORY", "-x[OPTIONAL]", "-x"
          specifies short style switch that takes ((*mandatory*)),
          ((*optional*)) and ((*no*)) argument, respectively.
        : "-[a-z]MANDATORY", "-[a-z][OPTIONAL]", "-[a-z]"
          special form short style switch that matches character
          range(not fullset of regular expression).
        : "=MANDATORY", "=[OPTIONAL]"
          argument style and description.
        : "description", ...
          ((*description*)) for this option.
      : (({Block}))
        ((*handler*)) to convert option argument to arbitrary (({Class})).
=end #'#"#`#
=begin private
--- OptionParser#notwice(obj, prv, msg)
    Checks never given twice an argument.
    ((*Called from OptionParser#switch only*))
    :Parameters:
      : ((|obj|))
        new argument.
      : ((|prv|))
        previously specified argument.
      : ((|msg|))
        exception message
=end #'#"#`#
=begin
--- OptionParser#on(*opts) [{...}]
--- OptionParser#def_option(*opts) [{...}]
--- OptionParser#on_head(*opts) [{...}]
--- OptionParser#def_head_option(*opts) [{...}]
--- OptionParser#on_tail(*opts) [{...}]
--- OptionParser#def_tail_option(*opts) [{...}]
    Defines option switch and handler. (({on_head})), (({def_head_option}))
    and (({on_tail})), (({def_tail_option})) put the switch at head
    and tail of summary, respectively.

    cf. ((<OptionParser#switch>)).
=end #'#"#`#
=begin
--- OptionParser#order(*argv) [{...}]
--- OptionParser#order!([argv = ARGV]) [{...}]
    Parses ((|argv|)) in order. When non-option argument encountered,
    yields it if called as iterator, otherwise terminates the parse
    process.
    Returns rest of ((|argv|)) left unparsed.
    
    (({order!})) takes argument array itself, and removes switches
    destructively.
    Defaults to parse ((|ARGV|)).
    :Parameters:
      : ((|argv|))
        command line arguments to be parsed.
      : (({Block}))
        called with each non-option argument.
=end #'#"#`#
=begin
--- OptionParser#permute(*argv)
--- OptionParser#permute!([argv = ARGV])
    Parses ((|argv|)) in permutation mode, and returns list of
    non-option arguments.
    
    (({permute!})) takes argument array itself, and removes switches
    destructively.
    Defaults to parse ((|ARGV|)).
    :Parameters:
      : ((|argv|))
        command line arguments to be parsed.
=end #'#"#`#
=begin
--- OptionParser#parse(*argv)
--- OptionParser#parse!([argv = ARGV])
    Parses ((|argv|)) in order when environment variable (({POSIXLY_CORRECT}))
    is set, otherwise permutation mode
    
    (({parse!})) takes argument array itself, and removes switches
    destructively.
    Defaults to parse ((|ARGV|)).
    :Parameters:
      : ((|argv|))
        command line arguments to be parsed.
=end #'#"#`#
=begin private
--- OptionParser#visit(id, *args) {block}
    Traverses (({stack}))s calling method ((|id|)) with ((|*args|)).
    :Parameters:
      : ((|id|))
        called method in each elements of (({stack}))s.
      : ((|*args|))
        passed to ((|id|)).
      : (({Block}))
        passed to ((|id|)).
=end #'#"#`#
=begin private
--- OptionParser#search(id, k)
    Searches ((|k|)) in stack for ((|id|)) hash, and returns it or yielded
    value if called as iterator.
    :Parameters:
      : ((|id|))
        searching table.
      : ((|k|))
        searching key.
      : (({Block}))
        yielded with the found value when succeeded.
=end #'#"#`#
=begin private
--- OptionParser#complete(typ, opt, *etc)
    Completes shortened long style option switch, and returns pair of
    canonical switch and switch descriptor((<OptionParser::Switch>)).
    :Parameters:
      : ((|id|))
        searching table.
      : ((|opt|))
        searching key.
      : ((|*pat|))
        optional pattern for completion.
      : (({Block}))
        yielded with the found value when succeeded.
=end #'#"#`#
=begin undocumented
--- OptionParser#load([filename])
    Loads options from file named as ((|filename|)). Does nothing when
    the file is not present. Returns whether successfuly loaded.
    :Parameters:
      : ((|filename|))
        option file name.  defaulted to basename of the program without
        suffix in a directory ((%~/.options%)).
=end #'#"#`#
=begin undocumented
--- OptionParser#environment([env])
    Parses environment variable ((|env|)) or its uppercase with spliting
    like as shell.
    :Parameters:
      : ((|env|))
        defaulted to basename of the program.
=end #'#"#`#
=begin
= Acceptable argument classes
=end #'#"#`#
=begin
: Object
  any string, and no conversion. this is fall-back.
=end #'#"#`#
=begin
: String
  any none-empty string, and no conversion.
=end #'#"#`#
=begin
: Integer
  Ruby/C-like integer, octal for (({0-7})) sequence, binary for
  (({0b})), hexadecimal for (({0x})), and decimal for others; with
  optional sign prefix. Converts to (({Integer})).
=end #'#"#`#
=begin
: Float
  Float number format, and converts to (({Float})).
=end #'#"#`#
=begin
: Numeric
  Generic numeric format, and converts to (({Integer})) for integer
  format, (({Float})) for float format.
=end #'#"#`#
=begin
: OptionParser::DecimalInteger
  Decimal integer format, to be converted to (({Integer})).
=end #'#"#`#
=begin
: OptionParser::OctalInteger
  Ruby/C like octal/hexadecimal/binary integer format, to be converted
  to (({Integer})).
=end #'#"#`#
=begin
: OptionParser::DecimalNumeric
  Decimal integer/float number format, to be converted to
  (({Integer})) for integer format, (({Float})) for float format.
=end #'#"#`#
=begin
: TrueClass
  Boolean switch, which means whether it is present or not, whether it
  is absent or not with prefix (({no-})), or it takes an argument
  (({yes/no/true/false/+/-})).
: FalseClass
  Similar to ((<TrueClass>)), but defaulted to (({false})).
=end #'#"#`#
=begin
: Array
  List of strings separated by ","
=end #'#"#`#
=begin
= Exceptions
=end #'#"#`#
=begin
== ((:OptionParser::ParseError:))
Base class of exceptions from ((<OptionParser>))
=== Superclass
(({RuntimeError}))
=== Constants
: OptionParser::ParseError::Reason
  Reason caused error.
=== Instance methods
--- OptionParser::ParseError#recover(argv)
    Push backs erred argument(s) to ((|argv|)).
--- OptionParser::ParseError#reason
    Returns error reason. Override this to I18N.
--- OptionParser::ParseError#inspect
    Returns inspection string.
--- OptionParser::ParseError#message
--- OptionParser::ParseError#to_s
--- OptionParser::ParseError#to_str
    Default stringizing method to emit standard error message.
=end #'#"#`#
=begin
== ((:OptionParser::AmbiguousOption:))
Raises when encountered ambiguously completable string.
=== Superclass
((<OptionParser::ParseError>))
=end #'#"#`#
=begin
== ((:OptionParser::NeedlessArgument:))
Raises when encountered argument for switch defined as which takes no
argument.
=== Superclass
((<OptionParser::ParseError>))
=end #'#"#`#
=begin
== ((:OptionParser::MissingArgument:))
Raises when no argument found for switch defined as which needs
argument.
=== Superclass
((<OptionParser::ParseError>))
=end #'#"#`#
=begin
== ((:OptionParser::InvalidOption:))
Raises when undefined switch.
=== Superclass
((<OptionParser::ParseError>))
=end #'#"#`#
=begin
== ((:OptionParser::InvalidArgument:))
Raises when the given argument does not match required format.
=== Superclass
((<OptionParser::ParseError>))
=end #'#"#`#
=begin
== ((:OptionParser::AmbiguousArgument:))
Raises when the given argument word can't completed uniquely.
=== Superclass
((<OptionParser::InvalidArgument>))
=end #'#"#`#
=begin
= Miscellaneous
=end #'#"#`#
=begin
== ((:OptionParser::Arguable:))
Extends command line arguments array to parse itself.
=end #'#"#`#
=begin
--- OptionParser::Arguable#options=(opt)
    Sets ((<OptionParser>)) object, when ((|opt|)) is (({false})) or
    (({nil})), methods ((<OptionParser::Arguable#options>)) and
    ((<OptionParser::Arguable#options=>)) are undefined.  Thus, there
    is no ways to access the ((<OptionParser>)) object via the
    receiver object.
=end #'#"#`#
=begin
--- OptionParser::Arguable#options
    Actual ((<OptionParser>)) object, automatically created if not
    yet.

    If called as iterator, yields with the ((<OptionParser>)) object
    and returns the result of the block. In this case, rescues any
    ((<OptionParser::ParseError>)) exceptions in the block, just emits
    error message to ((<STDERR>)) and returns (({nil})).

    :Parameters:
      : (({block}))
        Yielded with the ((<OptionParser>)) instance.

=end #'#"#`#
=begin
--- OptionParser::Arguable#order!
--- OptionParser::Arguable#permute!
--- OptionParser::Arguable#parse!
    Parses ((|self|)) destructively, and returns ((|self|)) just contains
    rest arguments left without parsed.
=end #'#"#`#
=begin private
Initializes instance variable.
=end #'#"#`#
=begin
== OptionParser::Acceptables
Acceptable argument classes.  Now contains (({DecimalInteger})),
(({OctalInteger})) and (({DecimalNumeric})).
see ((<Acceptable argument classes>)).
=end #'#"#`#
=begin example
= Example
<<< opttest.rb
=end #'#"#`#
