/*
 * sslconn.c
 * $Id: sslconn.c,v 1.13 2002/01/02 00:55:29 ttate Exp $
 */

#include "ruby.h"
#include "rbldap.h"
#include <sys/time.h>
#include <unistd.h>

#if defined(HAVE_LDAP_START_TLS_S)
# define USE_OPENLDAP_SSLCONN
#elif defined(HAVE_LDAPSSL_INIT)
# define USE_NSSLDAP_SSLCONN
#elif defined(HAVE_LDAP_SSLINIT)
# define USE_WLDAP32_SSLCONN
#endif

VALUE rb_cLDAP_SSLConn;

void
Init_ldap_sslconn()
{
  rb_cLDAP_SSLConn = rb_define_class_under(rb_mLDAP, "SSLConn", rb_cLDAP_Conn);
  rb_define_singleton_method(rb_cLDAP_SSLConn, "new", rb_ldap_sslconn_s_new, -1);
  rb_define_singleton_method(rb_cLDAP_SSLConn, "open", rb_ldap_sslconn_s_new, -1);
};

#ifdef USE_OPENLDAP_SSLCONN
static VALUE
rb_openldap_sslconn_s_new(int argc, VALUE argv[], VALUE klass)
{
  LDAP *cldap;
  char *chost = NULL;
  int cport = LDAP_PORT;

  VALUE arg1, arg2, arg3, arg4, arg5;
  VALUE conn;

  LDAPControl **serverctrls = NULL;
  LDAPControl **clientctrls = NULL;
  int version;
  int start_tls;

  switch( rb_scan_args(argc,argv,"05", &arg1, &arg2, &arg3, &arg4, &arg5) ){
  case 0:
    chost = ALLOCA_N(char, strlen("localhost")+1);
    strcpy(chost, "localhost");
    cport = LDAP_PORT;
    start_tls = 0;
    break;
  case 1:
    chost = STR2CSTR(arg1);
    cport = LDAP_PORT;
    start_tls = 0;
    break;
  case 2:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    start_tls = 0;
    break;
  case 3:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    start_tls = (arg3 == Qtrue) ? 1 : 0;
    break;
  case 4:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    start_tls = (arg3 == Qtrue) ? 1 : 0;
    serverctrls = rb_ldap_get_controls(arg4);
    break;
  case 5:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    start_tls = (arg3 == Qtrue) ? 1 : 0;
    serverctrls = rb_ldap_get_controls(arg4);
    clientctrls = rb_ldap_get_controls(arg5);
    break;
  default:
    rb_bug("rb_ldap_conn_new");
  };

  cldap = ldap_init(chost, cport);
  conn = rb_ldap_conn_new(klass,cldap);

  if( rb_block_given_p() ){
    rb_yield(conn);
  };

  ldap_get_option(cldap, LDAP_OPT_PROTOCOL_VERSION, &version);
  if( version < LDAP_VERSION3 ){
    version = LDAP_VERSION3;
    RLDAP_DATA_PTR(conn)->err =
      ldap_set_option(cldap, LDAP_OPT_PROTOCOL_VERSION, &version);
    Check_LDAP_Result(RLDAP_DATA_PTR(conn)->err);
  };

  if( start_tls ){
    RLDAP_DATA_PTR(conn)->err = ldap_start_tls_s(cldap, serverctrls, clientctrls);
    Check_LDAP_Result(RLDAP_DATA_PTR(conn)->err);
  }
  else{
    int opt = LDAP_OPT_X_TLS_HARD;
    RLDAP_DATA_PTR(conn)->err = ldap_set_option(cldap, LDAP_OPT_X_TLS, &opt);
    Check_LDAP_Result(RLDAP_DATA_PTR(conn)->err);
  };

  rb_obj_call_init(conn,argc,argv);
  return conn;
}
#endif /* USE_OPENLDAP_SSLCONN */


#ifdef USE_NSSLDAP_SSLCONN
static VALUE
rb_nssldap_sslconn_s_new(int argc, VALUE argv[], VALUE klass)
{
  RB_LDAP_DATA *ldapdata;
  LDAP *cldap;
  char *chost = NULL;
  char *certpath = NULL;
  int cport = LDAP_PORT;
  int csecure = 0;

  VALUE arg1, arg2, arg3, arg4;
  VALUE conn;

  switch( rb_scan_args(argc,argv,"04", &arg1, &arg2, &arg3, &arg4) ){
  case 0:
    chost = ALLOCA_N(char, strlen("localhost")+1);
    strcpy(chost, "localhost");
    cport = LDAP_PORT;
    csecure = 0;
    certpath = NULL;
    break;
  case 1:
    chost = STR2CSTR(arg1);
    cport = LDAP_PORT;
    csecure = 0;
    certpath = NULL;
    break;
  case 2:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    csecure = 0;
    certpath = NULL;
    break;
  case 3:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    csecure = (arg3 == Qtrue) ? 1 : 0;
    certpath = NULL;
    break;
  case 4:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    csecure = (arg3 == Qtrue) ? 1 : 0;
    certpath = (arg4 == Qnil) ? NULL : STR2CSTR(arg4);
    break;
  default:
    rb_bug("rb_ldap_conn_new");
  };

  /***
    ldapssl_client_init():
     http://docs.iplanet.com/docs/manuals/dirsdk/csdk41/html/function.htm#25963
     ldapssl_client_authinit():
     http://docs.iplanet.com/docs/manuals/dirsdk/csdk41/html/function.htm#26024
  ***/
  ldapssl_client_init(certpath, NULL);
  cldap = ldapssl_init(chost, cport, csecure);
  conn = rb_ldap_conn_new(klass, cldap);

  rb_obj_call_init(conn,argc,argv);
  return conn;
};
#endif /* USE_NSSLDAP_SSLCONN */

#if defined(USE_WLDAP32_SSLCONN)
static VALUE
rb_wldap32_sslconn_s_new(int argc, VALUE argv[], VALUE klass)
{
  LDAP *cldap;
  char *chost;
  int cport;
  int csecure;
  int version;

  VALUE arg1, arg2, arg3;
  VALUE conn;

  switch( rb_scan_args(argc,argv,"02",&arg1,&arg2, &arg3) ){
  case 0:
    chost = ALLOCA_N(char, strlen("localhost")+1);
    strcpy(chost, "localhost");
    cport = LDAP_PORT;
    csecure = 1;
    break;
  case 1:
    chost = STR2CSTR(arg1);
    cport = LDAP_PORT;
    csecure = 1;
    break;
  case 2:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    csecure = 1;
    break;
  case 3:
    chost = STR2CSTR(arg1);
    cport = NUM2INT(arg2);
    csecure = (arg3 == Qtrue) ? 1 : 0;
    break;
  default:
    rb_bug("rb_ldap_conn_new");
  };

  cldap = ldap_sslinit(chost,cport,csecure);
  conn = rb_ldap_conn_new(klass,cldap);

#if defined(HAVE_LDAP_GET_OPTION) && defined(HAVE_LDAP_SET_OPTION)
  ldap_get_option(cldap, LDAP_OPT_PROTOCOL_VERSION, &version);
  if( version < LDAP_VERSION3 ){
    version = LDAP_VERSION3;
    RLDAP_DATA_PTR(conn)->err =
      ldap_set_option(cldap, LDAP_OPT_PROTOCOL_VERSION, &version);
    Check_LDAP_Result(RLDAP_DATA_PTR(conn)->err);
  };
#endif

  rb_obj_call_init(conn,argc,argv);
  return conn;
};
#endif /* USE_WLDAP32_SSLCONN */

VALUE
rb_ldap_sslconn_s_new(int argc, VALUE argv[], VALUE klass)
{
#if defined(USE_OPENLDAP_SSLCONN)
  return rb_openldap_sslconn_s_new(argc, argv, klass);
#elif defined(USE_NSSLDAP_SSLCONN)
  return rb_nssldap_sslconn_s_new(argc, argv, klass);
#elif defined(USE_WLDAP32_SSLCONN)
  return rb_wldap32_sslconn_s_new(argc, argv, klass);
#else
  rb_notimplement();
#endif
};
