/*
 *  @(#)AutoDocJUnitFormatter.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.autodoc.v1.junit;

import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

import net.sourceforge.groboutils.autodoc.v1.spi.TestListenerFactory;


/**
 * Interfaces with the Ant JUnit task to add a Listener into JUnit for the
 * tests which report to the ITF framework.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 1, 2002
 * @version    $Date: 2003/02/10 22:52:12 $
 */
public class AutoDocJUnitFormatter extends AutoDocJUnitListener
        implements JUnitResultFormatter
{
    /**
     * Create a new listener, using super's method to load the default set
     * of delegated listeners.
     */
    public AutoDocJUnitFormatter()
    {
        super();
    }
    
    
    /**
     * Create a new listener using the given factories to specify all
     * sub-listeners.
     */
    public AutoDocJUnitFormatter( TestListenerFactory factories[] )
    {
        super( factories );
    }
    
    
    
    /**
     * The whole testsuite started.
     */
    public void startTestSuite(JUnitTest suite)
    {
        // ignore
    }

    /**
     * The whole testsuite ended.
     */
    public void endTestSuite(JUnitTest suite)
    {
        // ignore
    }

    /**
     * Sets the stream the formatter is supposed to write its results to.
     */
    public void setOutput(java.io.OutputStream out)
    {
        // ignore
    }

    /**
     * This is what the test has written to System.out
     */
    public void setSystemOutput( String out )
    {
        // ignore
    }

    
    /**
     * This is what the test has written to System.err
     */
    public void setSystemError( String err )
    {
        // ignore
    }
}

