/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Specifies methods for an HTTP server, which is
 * handling a single request from an HTTP client.
 * Methods must be called in specific order for a successful HTTP
 * exchange to take place.  The order of calls that must be made is:
 * <ul>
 * <li>{@link #readRequest}</li>
 * <li>{@link #writeResponse}</li>
 * <li>{@link #getOutputStream}</li>
 * </ul>
 */
public interface HttpServer
{
	/**
	 * Reads the HTTP <code>Request</code> information.
	 *
	 * @throws IllegalHttpStateException if the request was already read
	 */
	ServerRequest readRequest()
		throws IOException;

	/**
	 * Sends response data to the HTTP client.
	 *
	 * @throws IllegalHttpStateException if the request was not yet read
	 * or the response was already sent
	 * @throws HttpException if the server returned an invalid HTTP
	 * response
	 */
	void writeResponse(ServerResponse response)
		throws IOException;

	/**
	 * Returns a stream for writing data to, if data is to be sent to the
	 * client.  
	 *
	 * @throws IllegalHttpStateException if the request was not yet read,
	 * or the response was already sent, or data was sent by a
	 * <code>DataPoster<code>, or this method was already called
	 */
	OutputStream getOutputStream();

	/**
	 * Closes and releases any open connections or resources
	 * used by this server.
	 */
	void close()
		throws IOException;

}
