/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private Thread inputThread;
    private Thread errorThread;
    private OutputStream out;
    private OutputStream err;

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this.out = out;
        this.err = err;
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.inputThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        Thread result = new Thread(new StreamPumper(is, os));
        result.setDaemon(true);
        return result;
    }

    public void setProcessErrorStream(InputStream is) {
        this.createProcessErrorPump(is, this.err);
    }

    public void setProcessInputStream(OutputStream os) {
    }

    public void setProcessOutputStream(InputStream is) {
        this.createProcessOutputPump(is, this.out);
    }

    public void start() {
        this.inputThread.start();
        this.errorThread.start();
    }

    public void stop() {
        try {
            this.inputThread.join();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.errorThread.join();
        }
        catch (InterruptedException interruptedException) {}
    }
}

