/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Constant;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.FormSet;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;

public class ValidatorResources
implements Serializable {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$ValidatorResources == null ? (class$org$apache$commons$validator$ValidatorResources = ValidatorResources.class$("org.apache.commons.validator.ValidatorResources")) : class$org$apache$commons$validator$ValidatorResources));
    protected FastHashMap hFormSets = new FastHashMap();
    protected FastHashMap hConstants = new FastHashMap();
    protected FastHashMap hActions = new FastHashMap();
    protected static Locale defaultLocale = Locale.getDefault();
    static /* synthetic */ Class class$org$apache$commons$validator$ValidatorResources;

    public void put(FormSet fs) {
        if (fs != null) {
            String key = this.buildKey(fs);
            ArrayList<FormSet> formsets = (ArrayList<FormSet>)this.hFormSets.get((Object)key);
            if (formsets == null) {
                formsets = new ArrayList<FormSet>();
                this.hFormSets.put((Object)key, formsets);
            }
            if (!formsets.contains(fs)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding FormSet '" + fs.toString() + "'."));
                }
                formsets.add(fs);
            }
        }
    }

    public void addConstant(Constant c) {
        if (c != null && c.getName() != null && c.getName().length() > 0 && c.getValue() != null && c.getValue().length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding Global Constant: " + c.getName() + "," + c.getValue()));
            }
            this.hConstants.put((Object)c.getName(), (Object)c.getValue());
        }
    }

    public void addConstantParam(String name, String value) {
        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding Global Constant: " + name + "," + value));
            }
            this.hConstants.put((Object)name, (Object)value);
        }
    }

    public void addValidatorAction(ValidatorAction va) {
        if (va != null && va.getName() != null && va.getName().length() > 0 && va.getClassname() != null && va.getClassname().length() > 0 && va.getMethod() != null && va.getMethod().length() > 0) {
            va.process((Map)this.hConstants);
            this.hActions.put((Object)va.getName(), (Object)va);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add ValidatorAction: " + va.getName() + "," + va.getClassname()));
            }
        }
    }

    public ValidatorAction getValidatorAction(String key) {
        return (ValidatorAction)this.hActions.get((Object)key);
    }

    public Map getValidatorActions() {
        return Collections.unmodifiableMap(this.hActions);
    }

    protected String buildKey(FormSet fs) {
        String lang = fs.getLanguage();
        String country = fs.getCountry();
        String variant = fs.getVariant();
        String key = lang != null && lang.length() > 0 ? lang : "";
        key = key + (country != null && country.length() > 0 ? "_" + country : "");
        if ((key = key + (variant != null && variant.length() > 0 ? "_" + variant : "")).length() == 0) {
            key = defaultLocale.toString();
        }
        return key;
    }

    public Form get(Locale locale, Object formKey) {
        return this.get(locale.getLanguage(), locale.getCountry(), locale.getVariant(), formKey);
    }

    public Form get(String language, String country, String variant, Object formKey) {
        String key = null;
        key = language != null && language.length() > 0 ? language : "";
        key = key + (country != null && country.length() > 0 ? "_" + country : "");
        List v = (List)this.hFormSets.get((Object)(key = key + (variant != null && variant.length() > 0 ? "_" + variant : "")));
        if (v == null) {
            key = language != null && language.length() > 0 ? language : "";
            key = key + (country != null && country.length() > 0 ? "_" + country : "");
            v = (List)this.hFormSets.get((Object)key);
        }
        if (v == null) {
            key = language != null && language.length() > 0 ? language : "";
            v = (List)this.hFormSets.get((Object)key);
        }
        if (v == null) {
            key = defaultLocale.toString();
            v = (List)this.hFormSets.get((Object)key);
        }
        if (v == null) {
            return null;
        }
        Iterator formsets = v.iterator();
        while (formsets.hasNext()) {
            FormSet set = (FormSet)formsets.next();
            if (set == null || set.getForm(formKey) == null) continue;
            return set.getForm(formKey);
        }
        return null;
    }

    public void process() {
        this.hFormSets.setFast(true);
        this.hConstants.setFast(true);
        this.hActions.setFast(true);
        this.processForms();
    }

    public void processForms() {
        FormSet fs;
        Iterator formsetsIterator;
        List formsets;
        String defaultKey = defaultLocale.toString();
        Iterator i = this.hFormSets.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.equals(defaultKey)) continue;
            formsets = (List)this.hFormSets.get((Object)key);
            formsetsIterator = formsets.iterator();
            while (formsetsIterator.hasNext()) {
                fs = (FormSet)formsetsIterator.next();
                Iterator x = fs.getForms().keySet().iterator();
                while (x.hasNext()) {
                    String formKey = (String)x.next();
                    Form form = (Form)fs.getForms().get(formKey);
                    Form newForm = new Form();
                    newForm.setName(form.getName());
                    Form defaultForm = this.get(defaultLocale, formKey);
                    Iterator defaultFields = defaultForm.getFields().iterator();
                    while (defaultFields.hasNext()) {
                        Field defaultField = (Field)defaultFields.next();
                        String fieldKey = defaultField.getKey();
                        if (form.getFieldMap().containsKey(fieldKey)) {
                            newForm.addField((Field)form.getFieldMap().get(fieldKey));
                            continue;
                        }
                        Field field = this.getClosestLocaleField(fs, formKey, fieldKey);
                        newForm.addField((Field)field.clone());
                    }
                    fs.addForm(newForm);
                }
            }
        }
        Iterator i2 = this.hFormSets.values().iterator();
        while (i2.hasNext()) {
            formsets = (List)i2.next();
            formsetsIterator = formsets.iterator();
            while (formsetsIterator.hasNext()) {
                fs = (FormSet)formsetsIterator.next();
                if (fs.isProcessed()) continue;
                fs.process((Map)this.hConstants);
            }
        }
    }

    protected Field getClosestLocaleField(FormSet fs, String formKey, String fieldKey) {
        Form form;
        Field field = null;
        String language = fs.getLanguage();
        String country = fs.getCountry();
        String variant = fs.getVariant();
        if (!GenericValidator.isBlankOrNull(language) && !GenericValidator.isBlankOrNull(country) && !GenericValidator.isBlankOrNull(variant) && (form = this.get(language, country, variant, formKey)).getFieldMap().containsKey(fieldKey)) {
            field = (Field)form.getFieldMap().get(fieldKey);
        }
        if (field == null && !GenericValidator.isBlankOrNull(language) && !GenericValidator.isBlankOrNull(country) && (form = this.get(language, country, null, formKey)).getFieldMap().containsKey(fieldKey)) {
            field = (Field)form.getFieldMap().get(fieldKey);
        }
        if (field == null && !GenericValidator.isBlankOrNull(language) && (form = this.get(language, null, null, formKey)).getFieldMap().containsKey(fieldKey)) {
            field = (Field)form.getFieldMap().get(fieldKey);
        }
        if (field == null && (form = this.get(defaultLocale, formKey)).getFieldMap().containsKey(fieldKey)) {
            field = (Field)form.getFieldMap().get(fieldKey);
        }
        return field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

