/* MindgameWindow.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.windows;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ResourceBundle;
import javax.swing.JFrame;

import org.grinvin.gui.components.MindgameComponent;

/**
 *
 */
public class MindgameWindow extends JFrame {
    
    //
    private static final String BUNDLE_NAME = "org.grinvin.main.resources";
    
    public MindgameWindow() {
        super(ResourceBundle.getBundle(BUNDLE_NAME).getString ("window.mindgame.title"));
        MindgameComponent component = new MindgameComponent();
        component.addComponentListener(new MyComponentListener(this));
        setResizable(false);
        setContentPane(component);
        
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension componentSize = component.getPreferredSize();
        setLocation(screenSize.width / 2 - (componentSize.width / 2),
                screenSize.height / 2 - (componentSize.height / 2));
        
        pack();
    }
    
    public class MyComponentListener implements ComponentListener {
        
        //
        private JFrame frame;
        
        public MyComponentListener(JFrame frame) {
            this.frame = frame;
        }

        public void componentResized(ComponentEvent e) {
            frame.pack();
        }

        public void componentMoved(ComponentEvent e) { } // ignore

        public void componentShown(ComponentEvent e) { } // ignore

        public void componentHidden(ComponentEvent e) { } // ignore
        
    }

}
