#
# FILE            $Id: ASCIIFormatter.py,v 1.5 1998/02/04 20:11:45 dlarsson Exp $
#
# DESCRIPTION     Formatters for MIF and HTML manual formats.
#
# AUTHOR          SEISY/LKSB Daniel Larsson
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of ABB Industrial Systems
# not be used in advertising or publicity pertaining to
# distribution of the software without specific, written prior permission.
#
# ABB INDUSTRIAL SYSTEMS DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL ABB INDUSTRIAL SYSTEMS BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# Copyright (C) ABB Industrial Systems AB, 1996
# Unpublished work.  All Rights Reserved.
#
# HISTORY:
# $Log: ASCIIFormatter.py,v $
# Revision 1.5  1998/02/04 20:11:45  dlarsson
# Added definition list rendering.
#
# Revision 1.4  1998/02/04 19:15:26  dlarsson
# Fixed list rendering.
# Added generation of hyperlinks (just added the url in parenthesis
# after the link in the text)
#
# Revision 1.3  1996/09/06 10:09:47  omfadmin
# Use new markups in docstrings.
#
# Revision 1.2  1996/07/08  05:32:04  omfadmin
# Added dummy render_navigation.
#
# Revision 1.1  1996/06/24  10:07:57  omfadmin
# Initial revision
#
#

__author__ = "Daniel Larsson"
__version__ = "$Revision: 1.5 $"


class ASCII:
    """Manual formatter generating plain ASCII."""

    file_ext = '.txt'

    def _add_(self, txt):
	# Add text to the document
	self._text_ = self._text_ + txt

    # -----   THESE ARE THE REQUIRED METHODS  -----
    def __init__(self):
	# String to collect document text
	self._text_ = ''

    def render_title(self, manpage, title, marker):
	"""Render document title.

	*manpage* -- is a reference back to the manual page object.
	*title* -- is the title of the document.
	*marker* -- is a list of markers for the title. Markers
	  are used to implement indices. See the MIFFormatter
	  for how its used.
	"""
	self._add_(title+'\n\n')

    def render_navigation(self, top, prev, next):
	"""Render navigation buttons.

	~top~, ~prev~ and ~next~ are ManualPage instances."""
	pass

    def render_section(self, manpage, lvl, section, marker):
	"""Render a section heading.
	
	~lvl~ is an integer indicating the nesting depth of
	the section. The title is at level 0, top level sections
	at level 1, and so on.
	"""
	from string import upper, strip
	section = strip(section)
	if lvl == 1:
	    section = upper(section)
	self._add_(section+'\n'+'='*len(section)+'\n\n')

    def render_paragraph(self, manpage, para):
	"""Render a paragraph

	~para~ is the paragraph text.
	"""
	self._add_(para+'\n\n')

    def render_code(self, manpage, code):
	"""Render code snippet.
	
	~code~ is the code snippet.
	"""
	self._add_(code+'\n\n')

    def render_list(self, manpage, list):
	"""Render an unordered list (bullet list)

	~list~ is a list of items.
	"""

	def emit_list((listtype, list), lvl, recursive):
	    from gendoc.ManualPage import UN_LIST, OR_LIST

	    code = ''
	    ix = 0
	    for i in list:
	        if type(i) == type(''):
		    if listtype == UN_LIST:
			tag = '*'
		    else:
			ix = ix + 1
			tag = '%d.' % ix
		    code = code + ' '*lvl + tag + ' ' + i + '\n'
	        else:
                    code = code + recursive(i, lvl+1, recursive)
	    return code

	code = emit_list(list, manpage.cur_level(), emit_list)
	self._add_(code+'\n')

    def render_deflist(self, manpage, list):
	code = ''
	from regsub import gsub, compile
	from string import strip
	fixindent_re = compile('^[ \t]*')
	lvl = manpage.cur_level()

	for word, definition in list:
	    code = code + ' ' * lvl + strip(word) + '\n'
	    indent = ' ' * lvl + '  '
	    definition = gsub(fixindent_re, indent, definition)
	    code = code + definition + '\n\n'
	self._add_(code)

    def render_external_link(self, link, link_text):
	return '%s (%s)' % (link_text, link)

    def end(self):
	"""Return the rendered document.

	_IMPORTANT_: The same formatter object is very likely
	to be used for more than one ManualPage, so we must
	remove the text also (alternatively, we might initialise
	self._text_ in 'render_title', since it is always called
	first).
	"""
	text = self._text_
	self._text_ = ''
	return text

